<?php

if ( ! function_exists( 'edgtf_core_reviews_map' ) ) {
	function edgtf_core_reviews_map() {
		
		$reviews_panel = haar_edge_add_admin_panel(
			array(
				'title' => esc_html__( 'Reviews', 'edgtf-core' ),
				'name'  => 'panel_reviews',
				'page'  => '_page_page'
			)
		);
		
		haar_edge_add_admin_field(
			array(
				'parent'      => $reviews_panel,
				'type'        => 'text',
				'name'        => 'reviews_section_title',
				'label'       => esc_html__( 'Reviews Section Title', 'edgtf-core' ),
				'description' => esc_html__( 'Enter title that you want to show before average rating for each room', 'edgtf-core' ),
			)
		);
		
		haar_edge_add_admin_field(
			array(
				'parent'      => $reviews_panel,
				'type'        => 'textarea',
				'name'        => 'reviews_section_subtitle',
				'label'       => esc_html__( 'Reviews Section Subtitle', 'edgtf-core' ),
				'description' => esc_html__( 'Enter subtitle that you want to show before average rating for each room', 'edgtf-core' ),
			)
		);
		
		do_action( 'edgtf_hotel_room_action_single_fields' );
	}
	
	add_action( 'haar_edge_additional_page_options_map', 'edgtf_core_reviews_map', 75 ); //one after elements
}